<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace VendorDuplicator\Google\Service\Drive;

class AppIcons extends \VendorDuplicator\Google\Model
{
    /**
     * @var string
     */
    public $category;
    /**
     * @var string
     */
    public $iconUrl;
    /**
     * @var int
     */
    public $size;
    /**
     * @param string
     */
    public function setCategory($category)
    {
        $this->category = $category;
    }
    /**
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * @param string
     */
    public function setIconUrl($iconUrl)
    {
        $this->iconUrl = $iconUrl;
    }
    /**
     * @return string
     */
    public function getIconUrl()
    {
        return $this->iconUrl;
    }
    /**
     * @param int
     */
    public function setSize($size)
    {
        $this->size = $size;
    }
    /**
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppIcons::class, 'VendorDuplicator\Google_Service_Drive_AppIcons');
